<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content ">
		<div class="container-fluid">
			<div class="row pt-3">
				<div class="col-lg-3 col-md-6 col-12">
					<div class="card border-0 shadow-custom">
						<a href="<?php echo e(route('reports.payment_transactions')); ?>">
							<div class="card-body">
								<div class="d-flex justify-content-between align-items-center">
									<div class="content">
										<p class="text-dark text-lg mb-0  title"><?php echo e(format_amount($earnings)); ?></p>
										<p class="card-name mb-0 text-secondary  sub-title "><?php echo e(__('dashboard.earnings')); ?></p>
									</div>

									<div class="text-primary icon">
										<i class="fas fa-money-bill-alt fa-3x"></i>
									</div>
								</div>
							</div>
						</a>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 col-12">
					<a href="<?php echo e(route('member.index')); ?>">
						<div class="card border-0 shadow-custom">
							<div class="card-body">
								<div class="d-flex justify-content-between align-items-center">
									<div class="content">
										<p class="text-dark text-lg mb-0   title"><?php echo e($total_members); ?></p>
										<p class="card-name text-secondary mb-0  sub-title"><?php echo e(__('dashboard.total')); ?></p>
									</div>

									<div class="text-primary icon">
										<i class="fas fa-list fa-3x"></i>
									</div>
								</div>
							</div>
						</div>
					</a>
				</div>
				<div class="col-lg-3 col-md-6 col-12">
					<a href="<?php echo e(route('reports.member_information')); ?>">
						<div class="card border-0 shadow-custom">
							<div class="card-body">
								<div class="d-flex justify-content-between align-items-center">
									<div class="content">
										<p class="text-dark text-lg mb-0 title"><?php echo e($new_members); ?></p>
										<p class="card-name text-secondary mb-0  sub-title"><?php echo e(__('dashboard.total_joined')); ?></p>
									</div>

									<div class="text-primary  icon">
										<i class="fas fa-link fa-3x"></i>
									</div>
								</div>
							</div>
						</div>
					</a>
				</div>
				<div class="col-lg-3 col-md-6 col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-body">
							<div class="d-flex justify-content-between align-items-center">
								<div class="content">
									<p class="text-lg mb-0 text-dark title"><?php echo e($dashboard_time); ?></p>
									<p class="card-name text-secondary mb-0  sub-title"><?php echo e($dashboard_date); ?>

									</p>
								</div>

								<div class="text-primary icon">
									<i class="fas fa-calendar-alt fa-3x"></i>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-8 col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">	
							<h3 class="card-title">
								<?php echo e(__('dashboard.transactions_overview', ['from' => format_date($date1), 'to' =>
								format_date($date2)])); ?>

							</h3>
						</div>
						<div class="card-body">
							<canvas id="sales-chart" class="bar-chart-dashbord"></canvas>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-12">
					<div class="card border-0 shadow-custom ">
						<div class="card-header border-grey">
							<h3 class="card-title">
								<?php echo e(__('dashboard.latest_members')); ?>

							</h3>
						</div>
						<div class="card-body px-0 ">
							<ul class="users-list clearfix mb-0 bar-chart-dashbord">
								<?php if(count($latest_members) > 0): ?>
									<?php $__currentLoopData = $latest_members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<li>
										<a class="users-list-name" href="<?php echo e(route('member.edit', $member->id)); ?>">
											<div class="d-flex justify-content-center mb-1">
												<div class="users-list-image elevation-1"
													style="background-image: url('<?php echo e(get_image_path($member->profile_picture)); ?>');">
												</div>
											</div>
											<span class="text-secondary"><?php echo e($member->name); ?></span>
											<span class="users-list-date"><?php echo e(format_date($member->created_at)); ?></span>
										</a>
									</li>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<?php else: ?>
								<div class="d-flex justify-content-center align-items-center h-100">
									<p class="text-center mb-0"><?php echo e(__('dashboard.no_record_found')); ?></p>
								</div>
								<?php endif; ?>
							</ul>
						</div>
					</div>
				</div>
				<div class="col-lg-12 ">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<div class="d-flex align-items-center justify-content-between">
								<h3 class="card-title">
									<?php echo e(__('dashboard.latest_transactions')); ?>

								</h3>
								<a href="<?php echo e(route('reports.payment_transactions')); ?>" class="btn btn-primary btn-sm"><?php echo e(__('dashboard.view_all')); ?></a>
							</div>
						</div>
						<div class="card-body table-responsive">
							<table class="table custom-table-bordered table-valign-middle">
								<thead>
									<tr>
										<th class="nowrap"><?php echo e(__('dashboard.th_transaction_type')); ?></th>
										<th class="nowrap"><?php echo e(__('dashboard.th_payment_method')); ?></th>
										<th class="nowrap"><?php echo e(__('dashboard.th_dr_cr')); ?></th>
										<th class="nowrap"><?php echo e(__('dashboard.th_amount')); ?></th>
										<th class="fixed-width-td nowrap"><?php echo e(__('dashboard.th_date')); ?></th>
									</tr>
								</thead>
								<tbody>
									<?php $__currentLoopData = $latest_transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td class="nowrap text-capitalize"><?php echo e($transaction->type); ?></td>
											<td class="nowrap text-capitalize"><?php echo e($transaction->method); ?></td>
											<td class="nowrap text-capitalize"><?php echo e($transaction->dr_cr); ?></td>
											<td class="align-middle"><?php echo transaction_type($transaction); ?></td>
											<td class="nowrap"><?php echo e(format_date($transaction->date)); ?></td>	
										</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									<?php if(count($latest_transactions) == 0): ?>
									<tr>
										<td colspan="9">
											<p class="text-center mb-0"><?php echo e(__('dashboard.no_record_found')); ?></p>
										</td>
									</tr>
									<?php endif; ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js-script'); ?>
<script>
	$(function () {
		'use strict'

		var ticksStyle = {


		}

		var mode = 'index'
		var intersect = true

		var $salesChart = $('#sales-chart')
		var salesChart = new Chart($salesChart, {
			type: 'bar',
			data: {
				labels: ['SUN', 'MON', 'TUE', 'WED', 'THURS', 'FRI', 'SAT'],
				datasets: [
					{
						label: 'Plus Transactions (<?php echo e($currency_symbol); ?>)',
						backgroundColor: '#28a745',
						borderColor: '#28a745',
						fill: false,
						data: <?php echo json_encode($chart_data['income'], 15, 512) ?>,
					},
					{
						label: 'Minus Transactions (<?php echo e($currency_symbol); ?>)',
						backgroundColor: '#e74a3b',
						fill: false,
						data: <?php echo json_encode($chart_data['expense'], 15, 512) ?>
					},
				]
			},
			options: {
				maintainAspectRatio: false,
				tooltips: {
					mode: mode,
					intersect: intersect
				},
				hover: {
					mode: mode,
					intersect: intersect
				},
				legend: {
					display: true
				},
				scales: {
					yAxes: [{
						display: true,
						gridLines: {
							display: true
						},

						ticks: $.extend({
							beginAtZero: true,
							callback: function (value) {
								if (value >= 1000) {
									value /= 1000
									value += 'k'
								}
								return '<?php echo e($currency_symbol); ?>' + value
							}
						}, ticksStyle)
					}],
					xAxes: [{
						display: true,
						gridLines: {
							display: false
						},
						ticks: ticksStyle
					}]
				}
			}
		})
	})
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/dashboard.blade.php ENDPATH**/ ?>